//OHSAT GAMES MEGATILER TUTORIAL - TILES - https://www.ohsat.com/tutorial/megatiler/megatiler-1/
//MEGATEAMWORK Makes the MEGADREAM Work 
//SGDK Version: 2.0 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>

void loadLevel();

int main()
{   
    loadLevel();

   
    while(1)
    {
       
    
        //For versions prior to SGDK 1.60 use VDP_waitVSync instead.
        SYS_doVBlankProcess();
    }
    return (0);
}

void loadLevel(){
    //moved array from above main() & void loadLevel(); predeclaration 
    u8 level1[8][8] = {
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 1, 1, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 0, 1, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0}
    };

    u8 x = 0;
    u8 y = 0;
    u8 t = 0;

    for(y = 0; y < 8; y++){
        for (x = 0; x < 8; x++){
            t = level1[y][x];
            VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
        }
    }
    //moved from main() into loadLevel() to possibly use later for Levels.h header file. 
    VDP_loadTileSet(floortiles.tileset, 1, DMA);
    //VDP_setPalette(PAL1, floortiles.palette->data); //Deprecated command: VDP_setPalette
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);
}


////////////////////NOTES////////////////////

/*

1. Added tilesheet.png file to res>Tiles folder
2. Declared asset in resources.res as the following:
[TYPE] IMAGE [LABEL] floortiles [PATH] "Tiles/tilesheet.png" [OPTION] 0 
Note: For extra notes on resource decleration see bottom of NOTES section
3. Load assets via the following functions: 

    VDP_loadTileSet(floortiles.tileset, 1, DMA);
    //VDP_setPalette(PAL1, floortiles.palette->data); //Depricated command: VDP_setPalette
    PAL_setPalette(PAL1, floortiles.palette->data, DMA);

4. Create 8 x 8 array to draw tiles for grass [0] & wall [1] tiles. I recommend opening tilesheet.png in a tab
so you can visually reference it. Array label is 'level1'.

u8 level1[8][8] = {

x-coord |    0, 1, 2, 3, 4, 5, 6, 7     |y-coord   

            {0, 0, 0, 0, 0, 0, 0, 0},   | 0
            {0, 0, 0, 0, 0, 0, 0, 0},   | 1
            {0, 0, 0, 0, 1, 0, 0, 0},   | 2
            {0, 0, 0, 1, 1, 0, 0, 0},   | 3
            {0, 0, 0, 0, 1, 0, 0, 0},   | 4
            {0, 0, 0, 0, 1, 0, 0, 0},   | 5
            {0, 0, 0, 0, 1, 0, 0, 0},   | 6
            {0, 0, 0, 0, 0, 0, 0, 0}    | 7
}

A sub-array will be used to read the tile assignment in each row of the level1 array. 
The syntax is typically array[a][b] with 'a' referring to the y-coordinate and 'b' referring to the x-coordinate.
We will iterate a for() statement to call our sub-array within a function titled loadLevel(). 

5. Create function called loadLevel() to manage tile array(s).

void loadLevel(){
    u8 x = 0;
    u8 y = 0;
    u8 t = 0;

    for(y = 0; y < 8; y++){
        for (x = 0; x < 8; x++){
            t = level1[y][x];
            VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, FALSE, FALSE, t + 1), x, y);
        }
    }
}

Funciton summary: 
The for() statements have you define the x and y integers at a 0 value. 
Then, so long as the value is less than 8, the array value for x and y is incremented. 
Therefore, we start with 0 and stop at 7. 
To visualize this look at the 8x8 array labeled level1 above.   
This tells SGDK how to move through the rows of the array. 

As the lesson states, the first wall tile is referenced at t = level1[2][4]

t = level1[y][x]; tells SGDK which tile to reference. As shown above, 
t will default to a 0 value as it encounters the different values in the array. 
To know which tile to draw (0) for grass and (1) for a wall tile, t will check the array.
If the t array sees a 0, then we need to tell SGDK which tile to draw. 

Initially, we loaded the tileset with VDP_loadTileset() and put our first tile in position 1. 
Therefore, if t encounters a 0 value we need to tell it to reference position 1 in the tileset as that
is where the grass tile is placed. Then position 2 is the wall tile. 
To do this, we use VDP_setTileMapXY() and put in the t+1 to use to value of t from the array
and then add 1 to it. That means all values of 0 in the level1 array return a t value of 1. 
All values of 1 in the level1 array return a t value of 1. We then used the +1 to tell us to start with 
the tile at position 1 and count from there. 

If all of this sounds confusing then go back and reference the MEGARUNNER tutorial again if what Andrej and I
have said isn't clicking. 

6. (OPTIONAL) Move declerations and arrays into the loadLevel() function. 
It may be possible to take the format of this lesson and practice creating a header file. 

RESOURCES.RES SYNTAX BASICS

📌 resources.res Syntax Basics

The format is:

TYPE NAME FILE [options...]


Where:

TYPE = resource type (IMAGE, TILESET, SPRITE, MAP, etc.)

NAME = identifier used in C code

FILE = source asset file path

options = type-specific flags

🎨 1. IMAGE

Used for full-screen images or simple tiled graphics.

IMAGE img_title "res/title.png" 


Options:

TILE → forces conversion to tiles (default)

PALETTE → extract palette

Example:

IMAGE img_background "res/background.png" PAL PAL0

🧱 2. TILESET

Good for tiles (backgrounds, levels).

TILESET ts_level "res/level.png" 


Common options:

Option	Description
`COMPRESS NONE	FAST
PALETTE PAL0..PAL3	assign palette
`VDPPLAN A	B`

Example:

TILESET ts_forest "res/forest_tiles.png" PAL PAL2

🗺️ 3. MAP (tilemap)

For .tmx (Tiled) maps:

MAP map_level "res/level.tmx" 


Options include:

Option	Description
TILESET ts_name	use a tileset defined above
COMPRESS	compress the tilemap

Example:

MAP map_level1 "res/level1.tmx" TILESET ts_forest

🕹️ 4. SPRITE

Defines sprite graphics.

SPRITE spr_player "res/player.png"


Options:

Option	Description
TILESIZE 1	8×8 tiles
TILESIZE 2	16×16 tiles
COMPRESS	tile compression
PALETTE PAL0..PAL3	assign sprite palette

Example:

SPRITE spr_enemy "res/enemy.png" TILESIZE 2 PAL PAL1

🎨 5. PALETTE

If you want to define a separate palette file:

PALETTE pal_ui "res/ui.pal"


Or:

PALETTE pal_fx "res/vfx.act"

🔊 6. SOUND / MUSIC

SGDK supports several formats (XGM, WAV, VGM).

Example:

SOUND s_explosion "res/explosion.wav"
MUSIC mus_stage1 "res/stage1.xgm"

📁 7. TILESET + MAP Combined (TMX with Embedded Tiles)

Tiled .tmx files often include the tileset inside the TMX. SGDK can auto-extract:

MAP map_stage "res/stage.tmx" AUTO


Or:

MAP map_stage "res/stage.tmx" PAL PAL1

🔧 8. FONT

For a bitmap font:

FONT font_default "res/font.png" 

🧩 Complete Example resources.res
# Palettes
PALETTE pal_global "res/global.pal"

# Sprites
SPRITE spr_player "res/player.png" TILESIZE 2 PAL PAL0
SPRITE spr_enemy  "res/enemy.png"  TILESIZE 1 PAL PAL1

# Tileset + Map
TILESET ts_grass "res/grass_tiles.png" PAL PAL2
MAP map_level1   "res/level1.tmx" TILESET ts_grass

# UI Image
IMAGE img_title "res/title.png" PAL PAL3

# Audio
SOUND s_jump "res/jump.wav"
MUSIC mus_stage "res/stage1.xgm"

*/

/////////EXPERIMENTATION IDEAS///////////////

/*

Let's try seeing if it's possible to make a levels.h (and corresponding levels.c) to try and keep 
main.c clean. 

If you look at the SGDK\sample\game\platformer\src and \inc folders, you'll notice
player.h/player.c, map.h/map.c, levels.h/levels.c, etc., in their respective folders. 

The idea is to try and replicate this with this tutorial or any of the other previous tutorials
to get in the habit of compartmentalizing and optimizing our code. 

Reference: https://eiksoft.com/eik/sgdk.htm

See Tutorial 4: Header Files 

*/

///////////ERROR HANDLING////////////////////

